<?php
// Initialize the session
//require_once('./services/database.php');

session_start();

function checkAuth($email, $password) {
    include 'includes/dbconn.php'; // Database connection

    $stmt = $conn->prepare("SELECT user_id, company_id, password_hash FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row['password_hash'])) {
            // Correct password
            $_SESSION['user_id'] = $row['user_id'];
            $_SESSION['company_id'] = $row['company_id'];
            return true;
        }
    }
    return false; // Authentication failed
}


function setSesstion()
{
    $_SESSION["user"] = true;
}

function setCompany()
{
    $_SESSION["company_id"] = 1;
}

function logoutSesstion()
{
    $_SESSION["user"] = false;
}

